(defmeth vista-loglinear-proto :nested-model? (list1 list2)    
      (let* (
             (longer-list (if (>= (length list1) (length list2)) list1 list2))
             (shorter-list (if (< (length list1) (length list2)) list1 list2)))
             (null (set-difference shorter-list longer-list)))
             )
(defmeth vista-loglinear-proto :predictor-names ()
          (let* (
                 (terms (expand-hierarchy 
                         (list (iseq (length (send self :vars))))))
                 (terms-selected (select (send self :terms) 
                                         (position (send self :curr-model) 
                                                   (send self :models-adjusted-list))))
                (pn
                  (if (send self :level-labels) 
                      (send (send self :curr-model)
                            :my-make-names 
                            (select terms terms-selected)
                            (send self :vars)
                           (mapcar 'sort-data (send self :level-labels)))
                      (send (send self :curr-model)
                            :my-make-names 
                            (select terms terms-selected)
                            (send v-log-lin-proto :vars))))
                 )
         pn))

(defmeth scatterplot-proto :my-new-plot (x y)
  (let*
    ((num-points (send self :num-points))
     (color (send self :point-color (iseq num-points)))
     (symbol (send self :point-symbol (iseq num-points)))
     (state (send self :point-state (iseq num-points)))
     (selection (send self :selection))
     (showing (send self :point-showing (iseq num-points)))
     (labels (send self :point-label (iseq num-points)))
     )
    (send self :start-buffering)
    (send self :clear-points)
    (send self :add-points x y)
    (send self :point-color (iseq num-points) color)
    (send self :point-symbol (iseq num-points) symbol)
    (send self :point-state (iseq num-points) state)
    (send self :selection selection)
    (send self :point-label (iseq num-points) labels)
    (send self :redraw)
    (send self :buffer-to-screen)
     ))

(defmeth vista-loglinear-proto :reference-category-dialog (&optional (spreadplot-object nil))
  (let* ((labels (send self :level-labels))
         (choices 
          (mapcar #'(lambda (cats)
                      (send choice-item-proto 
                            :new cats 
                            ))
                      (send self :level-labels)))
         (Ok (send modal-button-proto :new "OK" 
                   :action #'(lambda ()
                               (send self :excluded-categories
                                     (mapcar #'(lambda (choice lab) 
                                                 (select lab (send choice :value)))
                                             choices labels))
                              (when spreadplot-object
                                    (send self :duplicate-model spreadplot-object))
                              (send dialog :close)
                               )))
         (apply (send modal-button-proto :new "Apply" 
                       :action #'(lambda () 
                                   (send self :excluded-categories
                                         (mapcar #'(lambda (choice lab) 
                                                     (select lab (send choice :value)))
                                                 choices labels))
                                   (when spreadplot-object
                                         (send self :duplicate-model spreadplot-object)) )))
         (dialog (send dialog-proto :new (list choices  (list Ok apply))))
         )
    (defmeth dialog :modal-dialog-return (&optional args)
      )
      
    dialog))
        

(defmeth vista-loglinear-proto :duplicate-model (spreadplot-object)
  (let* ((terms (expand-hierarchy 
                (list (iseq (length (send self :vars))))))
        (terms-in-model (select terms (select (send self :terms) 
                                               (send self :current-num-adjusted-model)))))
  (send self :terms (append (send self :terms) 
                                       (list (select (send self :terms) 
                                               (send self :current-num-adjusted-model)))))

  (send self :models-adjusted-list
                            (combine
                             (send self :models-adjusted-list)
                             (log-linear-model (send self :ncat)
                                               (send self :counts)
                                               terms-in-model
                                               (send self :vars)
                                               (mapcar 'sort-data (send self :level-labels))
                                               (send self :data-matrix)
                                               (send self :excluded-categories)
                                               )))

  (send self :model 
        (append (send self :model) 
                (list (select (send self :model) 
                        (send self :current-num-adjusted-model)))))
  (send self :curr-model 
        (car (reverse (send self :models-adjusted-list))))

       (send spreadplot-object :update-spreadplot "terms" 0 
             (select (send self :terms) 
                     (send self :current-num-adjusted-model)))))




(defmeth vista-loglinear-proto :rest-of-models (excluded-terms spreadplot-object)



  (let* (
         (terms (expand-hierarchy 
                (list (iseq (length (send self :vars))))))
         (included-terms (set-difference (iseq (length terms)) excluded-terms ))
                               
         )
    (mapcar #'(lambda (selection) 
                 (setf terms-in-model (select terms (combine excluded-terms selection)))
                 (send self :terms (append (send self :terms) (list (combine excluded-terms selection))))

                 (send self :models-adjusted-list
                       (combine
                        (send self :models-adjusted-list)
                        (log-linear-model (send self :ncat)
                                          (send self :counts)
                                          terms-in-model
                                          (send self :vars)
                                          (mapcar 'sort-data (send self :level-labels))
                                          (send self :data-matrix)
                                          (send self :excluded-categories)
                                          )))
                 
                 (send self :model 
                       (append (send self :model) 
                               (list (select (send self :list-terms) 
                                             (combine excluded-terms selection)))))
                 (send self :curr-model 
                       (car (reverse (send self :models-adjusted-list))))
                 
                 (send spreadplot-object :update-spreadplot "terms" 0 
                       (select (send self :terms) 
                               (send self :current-num-adjusted-model))))
            (reverse (cdr (all-subsets included-terms))))))


                            
 (defmeth vista-loglinear-proto :current-num-adjusted-model ()

   (position (send self :curr-model) (send self :models-adjusted-list)))
  
